%
% ECE 302
% Pendulum demonstration
%
% v2: added linearized model for comparison
%

clear all;
clear graphics;

% Pendulum without friction
theta0=30;
q10=pi*theta0/180;
q20=0;
q1L0=q10;
q2L0=0;
T=10;
sim('pendulumv2',10);
figure(1);
hold on;
plot(q1,q2,'k-');
plot(q1L,q2L,'r+');
grid on;
pbaspect([1 1 1])
xlabel('q1');
ylabel('q2');
title('phase portrait of pendulum without friction, \theta_0=30^o');
legend('nonlinear model','linear model')
hold off;
print('-dpdf','pendulumv2_30degrees','-fillpage');

theta0=120;
q10=pi*theta0/180;
q20=0;
q1L0=q10;
q2L0=0;
T=10;
sim('pendulumv2',10);
figure(2);
hold on;
plot(q1,q2,'k-');
plot(q1L,q2L,'r+');
grid on;
pbaspect([1 1 1])
xlabel('q1');
ylabel('q2');
title('phase portrait of pendulum without friction, \theta_0=120^o');
legend('nonlinear model','linear model')
hold off;
print('-dpdf','pendulumv2_120degrees','-fillpage');

% Pendulum with friction
f=0.3;
theta0=30;
q10=pi*theta0/180;
q20=0;
q1L0=q10;
q2L0=0;
T=10;
sim('pendulumfv2',10);
figure(3);
hold on;
plot(q1,q2,'k-');
plot(q1L,q2L,'r+');
grid on;
pbaspect([1 1 1])
xlabel('q1');
ylabel('q2');
title('phase portrait of pendulum with friction, \theta_0=30^o');
legend('nonlinear model','linear model')
hold off;
print('-dpdf','pendulumfv2_30degrees','-fillpage');

theta0=120;
q10=pi*theta0/180;
q20=0;
q1L0=q10;
q2L0=0;
T=10;
sim('pendulumfv2',10);
figure(4);
hold on;
plot(q1,q2,'k-');
plot(q1L,q2L,'r+');
grid on;
pbaspect([1 1 1])
xlabel('q1');
ylabel('q2');
title('phase portrait of pendulum with friction, \theta_0=120^o');
legend('nonlinear model','linear model')
hold off;
print('-dpdf','pendulumfv2_120degrees','-fillpage');




